#ifndef Ennemis_h
#define Ennemis_h

#include "Collide.h"
#include "Cbob.h"
#include "CPartEmmit.h"

#define TARG_MOV_SPEED 0.1f

//Classe d'interface nnemis
class CItEnnemi
{
    protected:
        static Vecteur *ciblePos; // cible
        static Vecteur *cibleVel;
    
        float shield; // bouclier
        unsigned char dmgS; // dgat de tire
        unsigned short tmShot; // temps en millisec entre 2 tires
        
    public:
        //CItEnnemi();
        //~CItEnnemi();
        
        //mettre une cible
        static void setCiblePosVel(Vecteur *ciblePosT,Vecteur *cibleVelT);
};

//Ennemis en mouvement
class CEnnemiMov : public CItEnnemi,public CCollideMv
{
    protected:
        float PRESSISION; // pressision de tire
        
    public:
        CEnnemiMov(float shield,unsigned char dmgS,unsigned short tmShot,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot);
        ~CEnnemiMov();
        
        //Calcul du temps qu'il y a avant impact sur la trajectorie de la cible
        float calculCibleImpact(float projSpeed,float rbase);
};

//Ennemis au sol
class CEnnemiFix : public CItEnnemi,public CCollide
{
    protected:
        float PRESSISION; // pressision de tire
    
    public:
        CEnnemiFix(float shield,unsigned char dmgS,unsigned short tmShot,float px,float py,float pz,float rayon,float coefElastic);
        ~CEnnemiFix();
        
        //Calcul du temps qu'il y a avant impact sur la trajectorie de la cible
        float calculCibleImpact(float projSpeed,float rbase,float h);
};

//Ennemis volant
class CEnnemiVolant : public CEnnemiMov
{
    private:
        CbobOBJ mod;//modle d'objet orient
        
        Vecteur rot;//angle de rotation
        Vecteur frot;//force de rotation
        
        unsigned char bRL;//code pour le prochaint tire (alternance de tire gauche/droite par exemple)
        float timeShot;//temps restant d'attente avant de tirer
        
        //Emmeteur de particule
        CPartEmmit mt;
        
        //politique de combat et indice du prototype de projectil  tirer
        //qui est un ocde spcial 3 bits code le mod de tire et 5 le type de projectil
        //0-4 = petit laser 5-9 = gros laser et 10-14 missiles
        unsigned char politique,idMProj;
        Vecteur targ;//cible d'orientation
        
        float cfZ,cfY;// coef de placement de l'mtteur de particules
    
    protected:
        
        virtual void applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg);
        virtual void applyExplosion(float dmg,float proxi);
        
        virtual bool frameMove(float elapsedTime);
        virtual void render();
        
        virtual void Shoot();//fonction de tire
        //virtual void projectilT(Vecteur &t,Vecteur &vl); // gnration du projectil (pas util ici  cause des modes de tires)
        
    public:
        CEnnemiVolant(float shield,unsigned char idMProj,unsigned char dmgS,unsigned short tmShot,unsigned char idM,float PRESSISION,float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot);
        virtual ~CEnnemiVolant();
};



//Lanceur de missile
class CEnnemiFixSol : public CEnnemiFix
{
    protected:
        //mod1=base mod2=coup mod3=tte mod4=bout du cannon
        Cbob *mod1,*mod4;
        CbobOBJ mod2,mod3;
        
        float h1;//hauteur de la base par rapport au centre
        float minRX,maxRX;//entre min et max de rotation en X de la tte
        float rotX,rotY;//orrientation de tire
        float frotX,frotY;//force de rotation
        
        unsigned char bRL;//code pour le prochaint tire (alternance de tire gauche/droite par exemple)
        float timeShot;//temps restant d'attente avant de tirer
        
        //politique de combat et indice rel pour cette fois du projectil
        //il correspond directement avec un prototype
        unsigned char politique,idMProj;
        Vecteur targ;//cible  pointer
    
    protected:
        
        virtual void applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg);
        virtual void applyExplosion(float dmg,float proxi);
        
        virtual bool frameMove(float elapsedTime);
        virtual void render();
        
        virtual void Shoot();//calcul des vecteurs de tires
        virtual void projectilT(Vecteur &t,Vecteur &vl,Vecteur &f);//gnration du projectil
        
        //calcul pour tirer en anticipant la trajectoir de la cible
        //cela vite de refaire tout le frameMove, le frameMove appel cette fonction
        //car il y a 2 type d'unit au sol (laser et missile ne vont pas  la mme vitesse)
        virtual float getImct();
        
        virtual void boom();//Explosion de l'unit au sol
        
    public:
        CEnnemiFixSol(float shield,unsigned char idMProj,unsigned char dmgS,unsigned short tmShot,unsigned char idM1,unsigned char idM2,unsigned char idM3,unsigned char idM4,float minRX,float maxRX,float PRESSISION,float px,float py,float pz,float rayon,float coefElastic);
        virtual ~CEnnemiFixSol();
};

//Turret laser
class CEnnemiFixSol2 : public CEnnemiFixSol
{
    protected:
        virtual void Shoot();//On redfinit le tire car c'est des lasers
        virtual void projectilT(Vecteur &t,Vecteur &vl,Vecteur &f);//le projectil tir donc
        
        virtual float getImct();//On redfinit l'appel du calcul d'impact pour indiquer que c'est la vitesse des lasers
        
        virtual void boom();//L'explosion est diffrente.
        
    public:
        CEnnemiFixSol2(float shield,unsigned char idMProj,unsigned char dmgS,unsigned short tmShot,unsigned char idM1,unsigned char idM2,unsigned char idM3,unsigned char idM4,float minRX,float maxRX,float PRESSISION,float px,float py,float pz,float rayon,float coefElastic);
        virtual ~CEnnemiFixSol2();
};


#endif

